import pyvisa
import pyvisa.constants as pycon
import time

def open_session(resource_name):

    rm = pyvisa.ResourceManager()
    instr = rm.open_resource(resource_name)

    return rm, instr


def write_instrument(instr, command):

    instr.write(command)

    return


def read_instrument(instr):

    response = instr.read()

    return response


def close_session(rm, instr):

    instr.close()
    rm.close()

    return


def status_config_serial_poll(instr):

    instr.clear()

    instr.write('*CLS;*ESE 1;*SRE 0;*OPC?')
    response = instr.read()

    return response


def serial_poll(instr, check_bit=5):

    bit_test = 0
    status_bit = 2**check_bit

    while bit_test != status_bit:

        status_byte = instr.read_stb()
        bit_test = status_byte & status_bit

    return


def status_config_srq(instr):
    
    event_type = pycon.EventType.service_request
    event_mech = pycon.EventMechanism.queue

    instr.clear()

    instr.enable_event(event_type, event_mech)
    instr.write('*CLS;*ESE 1;*SRE 32;*OPC?')
    response = instr.read()

    return response


def wait_for_srq(instr):

    event_type = pycon.EventType.service_request
    timeout = 30000

    response = instr.wait_on_event(event_type, timeout)

    return response


def close_session_srq(rm, instr):

    event_type = pycon.EventType.service_request
    event_mech = pycon.EventMechanism.queue
    
    instr.disable_event(event_type, event_mech)
    instr.close()
    rm.close()

    return


def dmm_command_string(measurement_key, range_key,
                       resfrac_key, zero_key,
                       sampcount_int):
    
    measurement = {'dc_voltage':'CONF:VOLT:DC',
                   'dc_current':'CONF:CURR:DC',
                   'resistance':'CONF:RES'}

    voltage_range = {'100 mV':0.1,
                     '1 V':1.0,
                     '10 V':10.0,
                     '100 V':100.0,
                     '1000 V':1000.0}

    current_range = {'0.1 mA':1.0e-4,
                     '1 mA':1.0e-3,
                     '10 mA':0.01,
                     '100 mA':0.1,
                     '1 A':1.0,
                     '3 A':3.0}
    
    resistance_range = {'100 ohm':1.0e2,
                        '1 kohm':1.0e3,
                        '10 kohm':1.0e4,
                        '100 kohm':1.0e5,
                        '1 Mohm':1.0e6,
                        '10 Mohm':1.0e7,
                        '100 Mohm':1.0e8}
    
    fraction_res = {'3 ppm (0.02 NPLC)':3.0,
                    '0.7 ppm (0.2 NPLC)':0.7,
                    '0.3 ppm (1 NPLC)':0.3,
                    '0.1 ppm (10 NPLC)':0.1,
                    '0.03 ppm (100 NPLC)':0.03,}
    
    auto_zero = {'On':':ZERO:AUTO ON',
                 'Off':':ZERO:AUTO OFF'}


    
    if measurement_key == 'dc_voltage':
        range = voltage_range[range_key]
    elif measurement_key == 'dc_current':
        range = current_range[range_key]
    elif measurement_key == 'resistance':
        range = resistance_range[range_key]

    fractional_resolution = (fraction_res[resfrac_key]
                             *1.0e-6)

    resolution = range*fractional_resolution

    
    command = measurement[measurement_key] + ' '
    command += f'{range:7.2e}' + ','
    command += f'{resolution:7.2e}' + ';'
    command += auto_zero[zero_key] + ';'
    command += (':SAMP:COUN' + ' '
                + f'{sampcount_int:d}' + ';')

    return command


def dmm_start_acquisition(instr, sync=False):

    if sync == False:
        command = ':INIT;:FETC?'
    elif sync == True:
        command = ':INIT;*OPC;:FETC?'

    instr.write(command)

    return


def response_string_to_numpy_array(response):


    response = response.split(',')
    numpy_array = np.genfromtxt(response,
                                delimiter=',')

    return numpy_array




if __name__ == '__main__':

    

    resource_name = \
           'USB0::0x0957::0x0607::MY47022122::INSTR'
    

    rm, dmm = open_session(resource_name)
    response = status_config_serial_poll(dmm)
    print(response)
    close_session(rm, dmm)



#    resource_name = \
#           'USB0::0x0957::0x0607::MY47022122::INSTR'
#    rm, dmm = open_session(resource_name)
#    response = status_config_srq(dmm)
#    print(response)
#    close_session(rm, dmm)



#    command = dmm_command_string('dc_voltage', '10 V',
#                                 '0.7 ppm (0.2 NPLC)',
#                                 'On', 10)
#    print(command)



#    command = dmm_command_string('dc_voltage', '10 V',
#                                 '0.7 ppm (0.2 NPLC)',
#                                 'On', 10)
#    resource_name = \
#           'USB0::0x0957::0x0607::MY47022122::INSTR'
#    rm, dmm = open_session(resource_name)
#    write_instrument(dmm, command)
#    close_session(rm, dmm)



#    command = dmm_command_string('dc_voltage', '10 V',
#                                 '0.7 ppm (0.2 NPLC)',
#                                 'On', 10)


#    resource_name = \
#           'USB0::0x0957::0x0607::MY47022122::INSTR'
#    rm, dmm = open_session(resource_name)
#    status_config_srq(dmm)
#    write_instrument(dmm, command)
#    dmm_start_acquisition(dmm, sync=True)

#    wait_for_srq(dmm)
#    response = read_instrument(dmm)
#    print(response)
#    close_session_srq(rm,dmm)

